using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Schema;
using System.IO;
using System.Windows.Forms;

namespace Transform
{
    public class clsXSDtool
    {
        XmlSchema myXmlSchema;
        string XSDpath;
        frmEDISmapSegment frmSegment;
        clsSchemaModel schemaModel;

        string heading = "";
        int repeats = 0;
        string dataType = "";
        int characters = 0;
        bool mandatory = false;
        string format = "";
        string value = "";
        string description = "";
        string code = "";

        public static bool error = false;

        public clsXSDtool(XmlSchema myXmlSchema, string heading) 
        {
            this.myXmlSchema = myXmlSchema;
            this.heading = heading;
        }

        public clsXSDtool(XmlSchema myXmlSchema, string XSDpath, frmEDISmapSegment frmSegment) 
        {
            this.myXmlSchema = myXmlSchema;
            this.XSDpath = XSDpath;
            this.frmSegment = frmSegment;
            this.heading = frmSegment.txtHeading.Text;
        }

        // Write out the XSD
        public void accessXSDSchema()
        {
            foreach (object item in myXmlSchema.Items)
            {
                if (item is XmlSchemaAttribute)
                    accessXSDSchemaAttribute((XmlSchemaAttribute)item);      //attribute
                else if (item is XmlSchemaComplexType)
                    accessXSDSchemaComplexType((XmlSchemaComplexType)item, false);  //complexType
                else if (item is XmlSchemaElement)
                    accessXSDSchemaElement((XmlSchemaElement)item);          //element
                else if (item is XmlSchemaAnnotation)
                    accessXSDSchemaAnnotation((XmlSchemaAnnotation)item);    //annotation
                else if (item is XmlSchemaAttributeGroup)
                    accessXSDSchemaAttributeGroup((XmlSchemaAttributeGroup)item); //attributeGroup
                else if (item is XmlSchemaNotation)
                    accessXSDSchemaNotation((XmlSchemaNotation)item);        //notation
                else if (item is XmlSchemaGroup)
                    accessXSDSchemaGroup((XmlSchemaGroup)item);
                else
                    Console.WriteLine("Not Implemented.");
            }
        }

        //XmlSchemaAttribute
        public void accessXSDSchemaAttribute(XmlSchemaAttribute attribute)
        {
            if (attribute.Name.Equals(heading))
            {
                if (!attribute.SchemaTypeName.IsEmpty)
                    dataType = attribute.SchemaTypeName.Name;
            }

            if (!attribute.RefName.IsEmpty)
            {
                //myXmlTextWriter.WriteQualifiedName(attribute.RefName.Name, attribute.RefName.Namespace);   
            }

            if (attribute.SchemaType != null)
                accessXSDSchemaSimpleType(attribute.SchemaType);
        }

        public void accessXSDSchemaComplexType(XmlSchemaComplexType complexType, bool daspth)
        {
            if (complexType.ContentModel != null)
            {
                if (complexType.ContentModel is XmlSchemaSimpleContent)
                {
                    XmlSchemaSimpleContent simpleContent = (XmlSchemaSimpleContent)complexType.ContentModel;
                    if (simpleContent.Content is XmlSchemaSimpleContentExtension && daspth)
                    {
                        XmlSchemaSimpleContentExtension simpleExtension = (XmlSchemaSimpleContentExtension)simpleContent.Content;
                        if (simpleExtension.BaseTypeName.Namespace.Equals(""))
                        {
                            XmlSchemaSimpleType simpleType = findXmlSchemaSimpleType(simpleExtension.BaseTypeName.Name);
                            accessXSDSchemaSimpleType(simpleType);
                        }
                        else
                            dataType = ((XmlSchemaSimpleContentExtension)simpleContent.Content).BaseTypeName.Name;
                    }
                }
                else if(complexType.ContentModel is XmlSchemaComplexContent)
                {
                    // not implement
                }
            }
            else
            {
                // access code and descrption
                if (complexType.Annotation != null && complexType.Annotation.Id.Equals(heading))
                {
                    foreach (object item in complexType.Annotation.Items)
                    {
                        if (item is XmlSchemaDocumentation)
                        {
                            if (((XmlSchemaDocumentation)item).Source.Equals("code"))
                            {
                                XmlNode[] xmlNodes = ((XmlSchemaDocumentation)item).Markup;
                                code = xmlNodes[0].Value;
                            }
                            else if (((XmlSchemaDocumentation)item).Source.Equals("description"))
                            {
                                XmlNode[] xmlNodes = ((XmlSchemaDocumentation)item).Markup;
                                description = xmlNodes[0].Value;
                            }
                        }
                    }
                }
                if (complexType.Particle != null)
                    accessXSDSchemaParticle(complexType.Particle);
                foreach (object o in complexType.Attributes)
                {
                    if (o is XmlSchemaAttribute)
                        accessXSDSchemaAttribute((XmlSchemaAttribute)o);
                }
            }
        }

        public XmlSchemaSimpleType findXmlSchemaSimpleType(string baseTypeName)
        {
            foreach (object item in myXmlSchema.Items)
                if (item is XmlSchemaSimpleType)
                    if (((XmlSchemaSimpleType)item).Name.Equals(baseTypeName))
                        return (XmlSchemaSimpleType)item;
            return null;
        }

        //XmlSchemaSimpleType
        public void accessXSDSchemaSimpleType(XmlSchemaSimpleType simpleType)
        {
            if (simpleType.Content is XmlSchemaSimpleTypeRestriction)
            {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)simpleType.Content;
                dataType = restriction.BaseTypeName.Name;
                foreach (object o in restriction.Facets)
                {
                    if (o is XmlSchemaMaxLengthFacet)
                        characters = Convert.ToInt32(((XmlSchemaMaxLengthFacet)o).Value);
                    else if (o is XmlSchemaPatternFacet)
                        format = ((XmlSchemaPatternFacet)o).Value;
                }
            }
            else if (simpleType.Content is XmlSchemaSimpleTypeList)
            {
                XmlSchemaSimpleTypeList list = new XmlSchemaSimpleTypeList();
                dataType = list.ItemTypeName.Name;
            }
            else
            {
                XmlSchemaSimpleTypeUnion union = new XmlSchemaSimpleTypeUnion();

            }
        }

        //XmlSchemaParticle
        public void accessXSDSchemaParticle(XmlSchemaParticle particle)
        {
            if (particle is XmlSchemaElement)
                accessXSDSchemaElement((XmlSchemaElement)particle);
            else if (particle is XmlSchemaSequence)
            {
                foreach (XmlSchemaParticle particle1 in ((XmlSchemaSequence)particle).Items)
                    accessXSDSchemaParticle(particle1);
            }
            else
                Console.WriteLine("Not Implemented for this type: {0}", particle.ToString());
        }

        // XmlSchemaElement
        public void accessXSDSchemaElement(XmlSchemaElement element)
        {
            if (element.Name.Equals(heading))
            {
                if (!element.SchemaTypeName.IsEmpty)
                {
                    dataType = element.SchemaTypeName.Name;
                    value = element.FixedValue;
                    decimal max = element.MaxOccurs;
                    decimal min = element.MinOccurs;
                    if (min == 0)
                        mandatory = true;
                    else
                        mandatory = false;
                    repeats = (int)(max - min);
                }
                if (element.ElementType is XmlSchemaSimpleType)
                    accessXSDSchemaSimpleType((XmlSchemaSimpleType)element.ElementType);
                else if (element.ElementType is XmlSchemaComplexType)
                    accessXSDSchemaComplexType((XmlSchemaComplexType)element.ElementType, true);
      

            }

            if (!element.RefName.IsEmpty)
            {
            }

            //if (element.SchemaType != null)
            //{
            //    if (element.SchemaType is XmlSchemaComplexType)
            //        WriteXmlSchemaComplexType((XmlSchemaComplexType)element.SchemaType);
            //    else
            //        WriteXmlSchemaSimpleType((XmlSchemaSimpleType)element.SchemaType);
            //}

            if (element.ElementType is XmlSchemaComplexType)
                accessXSDSchemaComplexType((XmlSchemaComplexType)element.ElementType, false);
            //else if (element.ElementType is XmlSchemaSimpleType)
            //    accessXSDSchemaSimpleType((XmlSchemaSimpleType)element.ElementType);


        }

        //XmlSchemaAnnotation
        public void accessXSDSchemaAnnotation(XmlSchemaAnnotation annotation)
        {
        }

        //XmlSchemaAttributeGroup
        public void accessXSDSchemaAttributeGroup(XmlSchemaAttributeGroup attributeGroup)
        {
        }

        //XmlSchemaGroup
        public void accessXSDSchemaGroup(XmlSchemaGroup group)
        {
        }

        //XmlSchemaNotation
        public void accessXSDSchemaNotation(XmlSchemaNotation notation)
        {
        }

        public clsSchemaModel fillSchemaModel()
        {
            schemaModel = new clsSchemaModel();
            schemaModel.heading = heading;
            schemaModel.dataType = dataType;
            schemaModel.characters = characters;
            schemaModel.code = code;
            schemaModel.description = description;
            schemaModel.mandatory = mandatory;
            schemaModel.repeats = repeats;
            schemaModel.value = value;
            schemaModel.format = format;
            return schemaModel;
        }

        // Write out the XSD
        public bool WriteXSDSchema()
        {
            error = false;
            foreach (object item in myXmlSchema.Items)
            {
                if (!error)
                {
                    if (item is XmlSchemaAttribute)
                        WriteXmlSchemaAttribute((XmlSchemaAttribute)item);      //attribute
                    else if (item is XmlSchemaComplexType)
                        WriteXmlSchemaComplexType((XmlSchemaComplexType)item);  //complexType
                    //else if (item is XmlSchemaSimpleType)
                    //  WriteXmlSchemaSimpleType((XmlSchemaSimpleType)item);    //simpleType
                    else if (item is XmlSchemaElement)
                        WriteXmlSchemaElement((XmlSchemaElement)item);          //element
                    else if (item is XmlSchemaAnnotation)
                        WriteXmlSchemaAnnotation((XmlSchemaAnnotation)item);    //annotation
                    else if (item is XmlSchemaAttributeGroup)
                        WriteXmlSchemaAttributeGroup((XmlSchemaAttributeGroup)item); //attributeGroup
                    else if (item is XmlSchemaNotation)
                        WriteXmlSchemaNotation((XmlSchemaNotation)item);        //notation
                    else if (item is XmlSchemaGroup)
                        WriteXmlSchemaGroup((XmlSchemaGroup)item);
                    else
                        Console.WriteLine("Not Implemented.");
                }
            }
            return error;
        }

        //XmlSchemaAttribute
        private void WriteXmlSchemaAttribute(XmlSchemaAttribute attribute)
        {
            if (attribute.Name.Equals(heading))
            {
                if (!attribute.SchemaTypeName.IsEmpty)
                {
                    //dataType = attribute.SchemaTypeName.Name;
                }
            }

            if (!attribute.RefName.IsEmpty)
            {
                //myXmlTextWriter.WriteQualifiedName(attribute.RefName.Name, attribute.RefName.Namespace);   
            }

            if (attribute.SchemaType != null)
                WriteXmlSchemaSimpleType(attribute.SchemaType);
        }

        private void WriteXmlSchemaComplexType(XmlSchemaComplexType complexType)
        {
            if (complexType.ContentModel != null)
            {
                if (complexType.ContentModel is XmlSchemaSimpleContent)
                {
                    XmlSchemaSimpleContent simpleContent = (XmlSchemaSimpleContent)complexType.ContentModel;
                    if (simpleContent.Content is XmlSchemaSimpleContentExtension)
                    {
                        XmlSchemaSimpleContentExtension simpleExtension = (XmlSchemaSimpleContentExtension)simpleContent.Content;
                        if (simpleExtension.BaseTypeName.Namespace.Equals(""))
                        {
                            XmlSchemaSimpleType simpleType = findXmlSchemaSimpleType(simpleExtension.BaseTypeName.Name);
                            WriteXmlSchemaSimpleType(simpleType);
                        }
                        else
                            simpleExtension.BaseTypeName = new XmlQualifiedName(frmSegment.cmbDataType.Text, "http://www.w3.org/2001/XMLSchema");
                    }
                }
                else if (complexType.ContentModel is XmlSchemaComplexContent)
                {
                    // not implement
                }
            }
            else
            {
                // write code and descrption
                if (complexType.Annotation != null && complexType.Annotation.Id.Equals(heading))
                {
                    foreach (object item in complexType.Annotation.Items)
                    {
                        if (item is XmlSchemaDocumentation)
                        {
                            if (((XmlSchemaDocumentation)item).Source.Equals("code"))
                            {
                                ((XmlSchemaDocumentation)item).Markup = TextToNodeArray(frmSegment.txtCode.Text);
                            }
                            else if (((XmlSchemaDocumentation)item).Source.Equals("description"))
                            {
                                ((XmlSchemaDocumentation)item).Markup = TextToNodeArray(frmSegment.txtDescription.Text);
                            }
                        }
                    }
                }
                if (complexType.Particle != null)
                    WriteXmlSchemaParticle(complexType.Particle);
                foreach (object o in complexType.Attributes)
                {
                    if (o is XmlSchemaAttribute)
                        WriteXmlSchemaAttribute((XmlSchemaAttribute)o);
                }
            }
        }

        //XmlSchemaSimpleType
        private void WriteXmlSchemaSimpleType(XmlSchemaSimpleType simpleType)
        {
            //XmlSchemaSimpleType lastNameType = new XmlSchemaSimpleType();
            //lastNameType.Name = "LastNameType";
            //XmlSchemaSimpleTypeRestriction lastNameRestriction = new
            //XmlSchemaSimpleTypeRestriction();
            //lastNameRestriction.BaseTypeName = new
            //XmlQualifiedName("string", "http://www.w3.org/2001/XMLSchema");
            //XmlSchemaMaxLengthFacet maxLength = new XmlSchemaMaxLengthFacet();
            //maxLength.Value = "20";
            //lastNameRestriction.Facets.Add(maxLength);
            //lastNameType.Content = lastNameRestriction;

            if (simpleType.Content is XmlSchemaSimpleTypeRestriction)
            {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)simpleType.Content;
                restriction.BaseTypeName = new XmlQualifiedName(frmSegment.cmbDataType.Text, "http://www.w3.org/2001/XMLSchema");
                foreach (object o in restriction.Facets)
                {
                    if (o is XmlSchemaMaxLengthFacet)
                    {
                        ((XmlSchemaMaxLengthFacet)o).Value = frmSegment.txtCharacters.Text;
                    }
                    else if (o is XmlSchemaPatternFacet)
                    {
                        ((XmlSchemaPatternFacet)o).Value = frmSegment.txtFormat.Text;
                    }
                }
                myXmlSchema.Compile(new ValidationEventHandler(ShowCompileError));
            }
            else if (simpleType.Content is XmlSchemaSimpleTypeList)
            {
                XmlSchemaSimpleTypeList list = new XmlSchemaSimpleTypeList();
                //dataType = list.ItemTypeName.Name;
            }
            else
            {
                XmlSchemaSimpleTypeUnion union = new XmlSchemaSimpleTypeUnion();

            }
        }

        //XmlSchemaParticle
        private void WriteXmlSchemaParticle(XmlSchemaParticle particle)
        {
            if (particle is XmlSchemaElement)
                WriteXmlSchemaElement((XmlSchemaElement)particle);
            else if (particle is XmlSchemaSequence)
            {
                foreach (XmlSchemaParticle particle1 in ((XmlSchemaSequence)particle).Items)
                    WriteXmlSchemaParticle(particle1);
            }
            else
                Console.WriteLine("Not Implemented for this type: {0}", particle.ToString());
        }

        // XmlSchemaElement
        private void WriteXmlSchemaElement(XmlSchemaElement element)
        {
            if (element.Name.Equals(heading))
            {
                if (element.ElementType is XmlSchemaComplexType)
                    WriteXmlSchemaComplexType((XmlSchemaComplexType)element.ElementType);
                else if (element.ElementType is XmlSchemaSimpleType)
                {
                    WriteXmlSchemaSimpleType((XmlSchemaSimpleType)element.ElementType);
                    element.FixedValue = frmSegment.txtValue.Text;
                    element.MaxOccurs = Convert.ToDecimal(frmSegment.txtRepeats.Text) + element.MinOccurs;
                    myXmlSchema.Compile(new ValidationEventHandler(ShowCompileError));
                    WriteCustomerSchema(myXmlSchema);
                }
                else if (!element.SchemaTypeName.IsEmpty)
                {
                    element.SchemaTypeName = new XmlQualifiedName(frmSegment.cmbDataType.Text, "http://www.w3.org/2001/XMLSchema");
                    element.FixedValue = frmSegment.txtValue.Text;
                    element.MaxOccurs = Convert.ToDecimal(frmSegment.txtRepeats.Text) + element.MinOccurs;
                    myXmlSchema.Compile(new ValidationEventHandler(ShowCompileError));
                    WriteCustomerSchema(myXmlSchema);
                }
            }

            if (!element.RefName.IsEmpty)
            {
            }

        }

        private void WriteCustomerSchema(XmlSchema myXmlSchema)
        {
            FileStream stream = File.OpenWrite(XSDpath);
            XmlTextWriter Writer = new XmlTextWriter(stream, new UTF8Encoding());
            Writer.Formatting = Formatting.Indented;
            myXmlSchema.Write(Writer);
            stream.Close();
        }

        private static void ShowCompileError(object sender, ValidationEventArgs e)
        {
            MessageBox.Show("Validation Error: " + e.Message);
            error = true; 
        }

        //XmlSchemaAnnotation
        private void WriteXmlSchemaAnnotation(XmlSchemaAnnotation annotation)
        {
        }

        //XmlSchemaAttributeGroup
        private void WriteXmlSchemaAttributeGroup(XmlSchemaAttributeGroup attributeGroup)
        {
        }

        //XmlSchemaGroup
        private void WriteXmlSchemaGroup(XmlSchemaGroup group)
        {
        }

        //XmlSchemaNotation
        private void WriteXmlSchemaNotation(XmlSchemaNotation notation)
        {
        }

        public static XmlNode[] TextToNodeArray(string text)
        {
            XmlDocument doc = new XmlDocument();
            return new XmlNode[1] {doc.CreateTextNode(text)};
        }

    }
}
